from datetime import date, timedelta

from marshmallow import fields, post_load, validate

from mail.ciao.ciao.api.schemas.base import BaseSchema


class SysWeekdaysSchema(BaseSchema):
    """
    Example: '{"repeat":false,"weekdays":[2]}'.
    Python weekdays start from 0 which is Monday, but sys.weekdays start with 1 hence `- 1` in `days_diff`.
    """

    weekdays = fields.List(fields.Integer, required=True, validate=validate.Length(min=1))

    @post_load
    def load_date(self, data: dict) -> date:
        weekday = data['weekdays'][0]
        today = date.today()
        days_diff = (weekday - 1 - today.weekday()) % 7
        return today + timedelta(days=days_diff)


_sys_weekdays_schema = SysWeekdaysSchema()


def parse_sys_weekdays(value: str) -> date:
    return _sys_weekdays_schema.loads(value).data
