from marshmallow import fields

from alice.megamind.protos.scenarios.request_pb2 import TScenarioApplyRequest, TScenarioRunRequest
from mail.ciao.ciao.api.schemas.megamind.arguments import ArgumentsSchema
from mail.ciao.ciao.api.schemas.megamind.base import BaseMegamindSchema
from mail.ciao.ciao.api.schemas.megamind.frame import SemanticFrameSchema
from mail.ciao.ciao.api.schemas.megamind.state import StateSchema


class ClientInfoSchema(BaseMegamindSchema):
    timezone = fields.String(required=True)
    app_id = fields.String(required=True)
    uuid = fields.String(required=True)


class TextSchema(BaseMegamindSchema):
    raw_utterance = fields.String()
    utterance = fields.String()


class VoiceSchema(BaseMegamindSchema):
    utterance = fields.String()


class InputSchema(BaseMegamindSchema):
    semantic_frames = fields.Nested(SemanticFrameSchema, many=True)
    text = fields.Nested(TextSchema)
    voice = fields.Nested(VoiceSchema)


class BaseRequestSchema(BaseMegamindSchema):
    request_id = fields.String()
    state = fields.Nested(StateSchema)
    client_info = fields.Nested(ClientInfoSchema, required=True)


class RunRequestSchema(BaseMegamindSchema):
    base_request = fields.Nested(BaseRequestSchema, required=True)
    input = fields.Nested(InputSchema)

    class Meta:
        strict = True
        protobuf = TScenarioRunRequest


class CommitRequestSchema(RunRequestSchema):
    arguments = fields.Nested(ArgumentsSchema)

    class Meta:
        strict = True
        protobuf = TScenarioApplyRequest


run_request_json_schema = RunRequestSchema(context={'protobuf': False})
run_request_protobuf_schema = RunRequestSchema(context={'protobuf': True})

commit_request_json_schema = CommitRequestSchema(context={'protobuf': False})
commit_request_protobuf_schema = CommitRequestSchema(context={'protobuf': True})
