from marshmallow import fields
from marshmallow_enum import EnumField

from mail.ciao.ciao.api.schemas.base import BaseSchema
from mail.ciao.ciao.api.schemas.entities.relativedelta import RelativedeltaSchema
from mail.ciao.ciao.api.schemas.entities.user_date import UserDateSchema
from mail.ciao.ciao.api.schemas.entities.user_time import UserTimeSchema
from mail.ciao.ciao.core.scenarios.create_event import CreateEventScenarioState


class CreateEventParamsSchema(BaseSchema):
    state = EnumField(CreateEventScenarioState, by_value=True)
    date_start = fields.Nested(UserDateSchema, allow_none=True)
    time_start = fields.Nested(UserTimeSchema, allow_none=True)
    date_end = fields.Nested(UserDateSchema, allow_none=True)
    time_end = fields.Nested(UserTimeSchema, allow_none=True)
    duration = fields.Nested(RelativedeltaSchema, allow_none=True)
    event_name = fields.String(allow_none=True)
    all_day = fields.Boolean()
