from marshmallow import fields
from marshmallow_enum import EnumField

from mail.ciao.ciao.api.schemas.base import BaseSchema
from mail.ciao.ciao.api.schemas.entities.event import EventSchema
from mail.ciao.ciao.core.scenarios.event_list import EventListScenarioState


class EventListParamsSchema(BaseSchema):
    state = EnumField(EventListScenarioState, by_value=True)
    events = fields.Nested(EventSchema, many=True)
    day = fields.Date()
    found_event = fields.Nested(EventSchema, allow_none=True)
