from marshmallow import fields
from marshmallow_enum import EnumField

from mail.ciao.ciao.api.schemas.base import BaseSchema
from mail.ciao.ciao.api.schemas.entities.event import EventSchema
from mail.ciao.ciao.api.schemas.entities.user_date import UserDateSchema
from mail.ciao.ciao.api.schemas.entities.user_time import UserTimeSchema
from mail.ciao.ciao.core.scenarios.reschedule_event import RescheduleEventScenarioState


class RescheduleEventParamsSchema(BaseSchema):
    state = EnumField(RescheduleEventScenarioState, by_value=True)
    event = fields.Nested(EventSchema)
    new_date_start = fields.Nested(UserDateSchema, allow_none=True)
    new_time_start = fields.Nested(UserTimeSchema, allow_none=True)
