from sendr_core.action import BaseAction as BAction

from mail.ciao.ciao.core.context import CORE_CONTEXT, CoreContext
from mail.ciao.ciao.interactions import InteractionClients


class BaseAction(BAction[CoreContext]):
    context = CORE_CONTEXT

    def __init__(self):
        super().__init__()
        self._clients = InteractionClients(self.logger, self.request_id)

    @property
    def clients(self) -> InteractionClients:
        return self._clients

    async def _run(self):
        with self.logger:
            async with self.clients:
                return await super()._run()
