from dataclasses import dataclass, field
from enum import Enum, unique
from typing import List


@dataclass
class Event:
    id: str
    name: str
    human_readable: str


@unique
class Action(Enum):
    CREATE_EVENT_START_DATE = 'calendar.create_event_start_date'
    CREATE_EVENT_START_TIME = 'calendar.create_event_start_time'
    CREATE_EVENT_NAME = 'calendar.create_event_name'
    CREATE_EVENT_DURATION = 'calendar.create_event_duration'
    EVENT_CREATED = 'calendar.event_created'


@unique
class Intent(Enum):
    EVENT_LIST = 'calendar.event_list'
    CREATE_EVENT = 'calendar.create_event'


@dataclass
class Analytics:
    intent: Intent
    actions: List[Action] = field(default_factory=list)
    events: List[Event] = field(default_factory=list)
