import urllib.parse as urlparse
from dataclasses import dataclass
from datetime import date
from urllib.parse import urlencode

from mail.ciao.ciao.conf import settings
from mail.ciao.ciao.utils.gettext import gettext


@dataclass
class Button:
    title: str


@dataclass
class UriButton(Button):
    uri: str


@dataclass
class TypeTextButton(Button):
    text: str


def get_calendar_day_button(day: date) -> UriButton:
    parsed = urlparse.urlparse(settings.CALENDAR_UI_DAY_URL)
    query = dict(urlparse.parse_qsl(parsed.query))
    query['show_date'] = day.isoformat()
    parsed = parsed._replace(query=urlencode(query))
    return UriButton(
        title=gettext('Open calendar'),
        uri=urlparse.urlunparse(parsed),
    )
