from enum import Enum, unique
from typing import Optional

from mail.ciao.ciao.utils.logging import LOGGER


@unique
class FrameName(Enum):
    CREATE_EVENT = 'alice.mail_ciao_create_event'
    CREATE_EVENT_SUBSEQUENT = 'alice.mail_ciao_create_event_subsequent'
    DELETE_EVENT = 'alice.mail_ciao_delete_event'
    EVENT_LIST = 'alice.mail_ciao_event_list'
    EVENT_LIST_SUBSEQUENT = 'alice.mail_ciao_event_list_subsequent'
    FIND_EVENT = 'alice.mail_ciao_find_event'
    RESCHEDULE_EVENT = 'alice.mail_ciao_reschedule_event'
    UNKNOWN_FRAME = 'unknown_frame'

    @classmethod
    def from_string(cls, value: Optional[str]) -> 'FrameName':
        try:
            return cls(value)
        except ValueError:
            logger = LOGGER.get()
            with logger:
                logger.context_push(frame_name_raw=value)
                logger.info('Unknown frame name.')
            return cls.UNKNOWN_FRAME


@unique
class SysSlotType(Enum):
    DATE = 'sys.date'
    WEEKDAYS = 'sys.weekdays'
    STRING = 'string'
    TIME = 'sys.time'
    DATETIME_RANGE = 'sys.datetime_range'
    CUSTOM_DATE_ENUM = 'custom.date_enum'
    CUSTOM_EVENT_LIST_SINGLE_EVENT = 'custom.event_list_single_event'
    CUSTOM_CREATE_EVENT_ALL_DAY = 'custom.create_event_all_day'


@unique
class YesNo(Enum):
    YES = 'yes'
    NO = 'no'


@unique
class DateEnum(Enum):
    TODAY = 'today'
    TOMORROW = 'tomorrow'


@unique
class EventListSingleEvent(Enum):
    FIRST = 'first'
    NEXT = 'next'


@unique
class CreateEventAllDay(Enum):
    ALL_DAY = 'all_day'
