from dataclasses import dataclass, field
from enum import Enum
from typing import List, Optional, Tuple, Type, Union

from mail.ciao.ciao.core.entities.analytcs import Analytics
from mail.ciao.ciao.core.entities.button import Button
from mail.ciao.ciao.core.entities.enums import FrameName, SysSlotType

RequestedSlotType = Tuple[str, Union[Type[Enum], SysSlotType]]


@dataclass
class ScenarioResponse:
    text: Optional[str] = None
    speech: Optional[str] = None
    commit: bool = False
    irrelevant: bool = False
    analytics: Optional[Analytics] = None
    error: Optional[str] = None

    buttons: List[Button] = field(default_factory=list)
    expected_frames: List[FrameName] = field(default_factory=list)
    suggests: List[Button] = field(default_factory=list)

    # Only used when requesting slot. By default reuses frame_name from initial request.
    frame_name: Optional[FrameName] = None
    requested_slot: Optional[RequestedSlotType] = None
    contains_sensitive_data: bool = False

    expects_continuation: Optional[bool] = None

    def __post_init__(self):
        if self.speech is None:
            self.speech = self.text

    @property
    def should_listen(self) -> bool:
        if self.expects_continuation is not None:
            return self.expects_continuation
        return self.requested_slot is not None


IRRELEVANT_RESPONSE = ScenarioResponse(irrelevant=True)
