from dataclasses import dataclass
from typing import TYPE_CHECKING, Generic, Optional, Tuple, TypeVar, Union

from mail.ciao.ciao.core.entities.missing import MissingType
from mail.ciao.ciao.core.entities.scenario_response import ScenarioResponse

if TYPE_CHECKING:
    from mail.ciao.ciao.core.scenarios.base import BaseScenario  # noqa

T = TypeVar('T')


@dataclass(frozen=True)
class ScenarioResult(Generic[T]):
    response: Optional[ScenarioResponse] = None
    value: Union[MissingType, T] = MissingType.MISSING
    call: Optional[Tuple['BaseScenario', str]] = None

    def __post_init__(self):
        assert any((
            self.response is not None,
            self.value is not MissingType.MISSING,
            self.call is not None,
        )), 'ScenarioResult must have any non default attributes.'

        assert self.call is None or (self.response is None and self.value is MissingType.MISSING), \
            'ScenarioResult must have no response or value if call is present.'
