from typing import Any, Optional

from sendr_core.exceptions import BaseCoreError, CoreFailError  # noqa

from mail.ciao.ciao.core.entities.analytcs import Analytics


class CoreNotFoundError(BaseCoreError):
    message = 'NOT_FOUND_ERROR'


class CoreIrrelevantScenarioError(BaseCoreError):
    message = 'IRRELEVANT_SCENARIO'

    def __init__(self, *args: Any, analytics: Optional[Analytics] = None):
        super().__init__(*args)
        self.analytics: Optional[Analytics] = analytics
