from typing import Dict, Tuple, Type

from mail.ciao.ciao.core.scenarios.base import BaseScenario
from mail.ciao.ciao.core.scenarios.create_event import CreateEventScenario
from mail.ciao.ciao.core.scenarios.delete_event import DeleteEventScenario
from mail.ciao.ciao.core.scenarios.event_list import EventListScenario
from mail.ciao.ciao.core.scenarios.find_event import FindEventScenario
from mail.ciao.ciao.core.scenarios.reschedule_event import RescheduleEventScenario

_ALL_SCENARIOS: Tuple[Type[BaseScenario], ...] = (
    CreateEventScenario,
    DeleteEventScenario,
    EventListScenario,
    FindEventScenario,
    RescheduleEventScenario,
)

SCENARIO_BY_NAME: Dict[str, Type[BaseScenario]] = {
    scenario_cls.scenario_name: scenario_cls
    for scenario_cls in _ALL_SCENARIOS
}
