from dataclasses import dataclass
from datetime import datetime
from enum import Enum, unique


@unique
class EventType(Enum):
    USER = 'user'


@dataclass
class Event:
    event_id: int
    external_id: str
    name: str
    description: str
    start_ts: datetime
    end_ts: datetime
    others_can_view: bool
    sequence: int
    all_day: bool
