from typing import Dict, Type

from sendr_interactions.exceptions import InteractionResponseError


class BaseCalendarError(InteractionResponseError):
    pass


class UnknownCalendarError(BaseCalendarError):
    pass


class EventNotFoundCalendarError(BaseCalendarError):
    pass


ERROR_NAME_MAPPING: Dict[str, Type[BaseCalendarError]] = {
    'event-not-found': EventNotFoundCalendarError,
}


def get_error_by_name(name: str) -> Type[BaseCalendarError]:
    return ERROR_NAME_MAPPING.get(name, UnknownCalendarError)
