import logging
import uuid

from sendr_qlog import LoggerContext

from mail.ciao.ciao.conf import settings
from mail.ciao.ciao.core.actions.base import BaseAction
from mail.ciao.ciao.interactions import InteractionClients
from mail.ciao.ciao.interactions.base import BaseInteractionClient, create_connector
from mail.ciao.ciao.utils.logging import LOGGER


def create_shell_context():
    BaseInteractionClient.CONNECTOR = create_connector()
    request_id = 'manual_' + uuid.uuid4().hex
    logger = LoggerContext(logging.getLogger(), {'request_id': request_id})
    clients = InteractionClients(logger, request_id)

    LOGGER.set(logger)
    BaseAction.context.logger = logger
    BaseAction.context.request_id = request_id

    return {
        'clients': clients,
        'logger': logger,
        'request_id': request_id,
        'settings': settings,
    }
