from datetime import date, datetime
from typing import Union

from .gettext import gettext

_MONTHS = {
    12: 'декабрь', 1: 'январь', 2: 'февраль',
    3: 'март', 4: 'апрель', 5: 'май',
    6: 'июнь', 7: 'июль', 8: 'август',
    9: 'сентябрь', 10: 'октябрь', 11: 'ноябрь',
}

_MONTHS_GENITIVE = {
    12: 'декабря', 1: 'января', 2: 'февраля',
    3: 'марта', 4: 'апреля', 5: 'мая',
    6: 'июня', 7: 'июля', 8: 'августа',
    9: 'сентября', 10: 'октября', 11: 'ноября',
}


def format_month(month: int, genitive: bool = False) -> str:
    return _MONTHS_GENITIVE[month] if genitive else _MONTHS[month]


def format_time(dt: datetime) -> str:
    return dt.strftime('%H:%M')


def format_date(dt: Union[date, datetime], today: date) -> str:
    formatted_year = '' if dt.year == today.year else f' {dt.year} ' + gettext('Year (genitive).')
    return f'{dt.day} {format_month(dt.month, genitive=True)}{formatted_year}'


def format_datetime(dt: datetime, today: date) -> str:
    return f'{format_date(dt, today)} {format_time(dt)}'
