from gettext import GNUTranslations
from io import BytesIO
from typing import Optional

from library.python import resource  # type: ignore
from mail.ciao.ciao.conf import settings


class Translation:
    _translation: Optional[GNUTranslations] = None

    @property
    def translation(self) -> GNUTranslations:
        if self._translation is None:
            if settings.MO_USE_LOCAL:
                mo_file = open(settings.MO_PATH, 'rb')
            else:
                mo_file = BytesIO(resource.find(settings.MO_PATH))
            self._translation = GNUTranslations(mo_file)  # type: ignore
        return self._translation

    def __getattr__(self, name):
        def wrapped(*args, **kwargs):
            return getattr(self.translation, name)(*args, **kwargs)

        return wrapped


_TRANSLATION = Translation()
gettext = _TRANSLATION.gettext
ngettext = _TRANSLATION.ngettext
