from sendr_qstats import AggSuff, Counter, Histogram, IntSuff, MetricsRegistry, MetricSuffix

from mail.ciao.ciao.conf import settings

REGISTRY = MetricsRegistry(ctype=settings.get('STATS_CTYPE'))

ABS_MAX_SUFF = MetricSuffix(
    IntSuff.absolute.value,
    AggSuff.max.value,
    AggSuff.max.value,
    AggSuff.trnsp.value,
)

interaction_response_time = Histogram(
    'response_time',
    buckets=settings.STATS_RESPONSE_TIME_BUCKETS,
    labelnames=('service',),
    registry=REGISTRY,
)
interaction_response_status = Counter(
    'response_status',
    labelnames=('service', 'status'),
    registry=REGISTRY,
)

interaction_method_response_time = Histogram(
    'response_method_time',
    buckets=settings.STATS_RESPONSE_TIME_BUCKETS,
    labelnames=('service', 'method'),
    registry=REGISTRY,
)
interaction_method_response_status = Counter(
    'response_method_status',
    labelnames=('service', 'method', 'status'),
    registry=REGISTRY,
)

scenario_request_time = Histogram(
    'scenario_request_time',
    labelnames=('scenario_name', 'request_type'),
    buckets=settings.STATS_RESPONSE_TIME_BUCKETS,
    registry=REGISTRY
)
scenario_request_count = Counter(
    'scenario_request_count',
    labelnames=('scenario_name', 'request_type'),
    registry=REGISTRY
)

scenario_event_create_time = Histogram(
    'scenario_event_create_time',
    labelnames=('step',),
    buckets=settings.STATS_RESPONSE_TIME_BUCKETS,
    registry=REGISTRY
)
scenario_event_create_count = Counter(
    'scenario_event_create_count',
    labelnames=('step',),
    registry=REGISTRY
)
