CREATE OR REPLACE FUNCTION rpop.add_initial_imap_messages(
    i_folder_id bigint,
    i_uidls     bigint[],
    i_modulo    bigint DEFAULT 64
) RETURNS integer AS $$
DECLARE
    div bigint;
    res integer;
BEGIN
    SELECT i_folder_id % i_modulo INTO div;

    WITH uidls AS (
        SELECT uidl
            FROM unnest(i_uidls) uidl
        ),
    collected AS (
        SELECT uidl
            FROM rpop.rpop_imap_uidls
          WHERE folder_id = i_folder_id
            AND folder_id % i_modulo = div
            AND uidl IN (SELECT uidl FROM uidls)
        )
    INSERT INTO rpop.rpop_imap_uidls
            (folder_id, uidl, collect_state)
        SELECT i_folder_id, uidl, 'initial'
            FROM uidls
          WHERE uidl NOT IN (SELECT uidl FROM collected);

    GET DIAGNOSTICS res = ROW_COUNT;
    RETURN res;
END;
$$ LANGUAGE 'plpgsql';
