create or replace function rpop.api_create(
    i_server text,
    i_port integer,
    i_login text,
    i_password text,
    i_use_ssl text,
    i_email text,
    i_delete_msg bigint,
    i_abook_sync_state smallint,
    i_date_unread timestamp,
    i_uname bigint,
    i_use_imap smallint,
    i_imap_root_folder text,
    i_is_oauth boolean default null,
    i_is_ng boolean default false,
    i_label text default null
)
returns bigint language plpgsql as
$BODY$
DECLARE
    i_popid bigint;
BEGIN
    select nextval('rpop.pop_s') into i_popid;

    insert into rpop.pop_profile(
        server,
        port,
        login,
        password,
        use_ssl,
        email,
        delete_msg,
        fname,
        ena_filters,
        bad_retries,
        abook_sync_state,
        date_unread,
        uname,
        popid,
        use_imap,
        imap_root_folder,
        is_oauth,
        is_ng,
        label
    ) values (
        i_server,
        i_port,
        i_login,
        i_password,
        i_use_ssl,
        i_email,
        i_delete_msg,
        'inbox',
        1,
        0,
        i_abook_sync_state,
        i_date_unread,
        i_uname,
        i_popid,
        i_use_imap,
        i_imap_root_folder,
        i_is_oauth,
        i_is_ng,
        i_label
    );

    return i_popid;
END
$BODY$;
