CREATE OR REPLACE FUNCTION rpop.api_edit_nopasswd(
    i_server text,
    i_port integer,
    i_login text,
    i_use_ssl text,
    i_email text,
    i_delete_msg bigint,
    i_use_imap smallint,
    i_imap_root_folder text,
    i_uname bigint,
    i_popid bigint,
    i_is_ng boolean default false,
    i_label text default null
)
returns integer as
$BODY$
DECLARE
    res integer;
BEGIN
    update rpop.pop_profile
    set
        server=i_server,
        port=i_port,
        login=i_login,
        use_ssl=i_use_ssl,
        email=i_email,
        delete_msg=i_delete_msg,
        use_imap=i_use_imap,
        imap_root_folder=i_imap_root_folder,
        bad_retries=0,
        is_ng=i_is_ng,
        label=i_label
    where uname=i_uname and popid=i_popid;

    GET DIAGNOSTICS res = ROW_COUNT;
    return res;
END
$BODY$
LANGUAGE 'plpgsql';
