CREATE OR REPLACE FUNCTION rpop.append_imap_uidl(
    i_folder_id bigint,
    i_uidl      bigint,
    i_modulo    bigint DEFAULT 64
) RETURNS integer AS $$
DECLARE
    div bigint;
    res integer;
BEGIN
    SELECT i_folder_id % i_modulo INTO div;
    UPDATE rpop.rpop_imap_uidls
        SET collect_state = 'collected'
        WHERE folder_id = i_folder_id
            AND uidl = i_uidl
            AND folder_id % i_modulo = div;

    IF NOT found THEN
        INSERT INTO rpop.rpop_imap_uidls
            (folder_id,
            uidl,
            collect_state)
        VALUES
            (i_folder_id,
            i_uidl,
            'collected');
    END IF;

    GET DIAGNOSTICS res = ROW_COUNT;
    RETURN res;
END;
$$ LANGUAGE 'plpgsql';
