CREATE OR REPLACE FUNCTION rpop.collect_status(
    i_popid bigint,
    i_modulo bigint DEFAULT 64
) RETURNS TABLE(
    folder bigint,
    msg_count bigint,
    msg_collected bigint,
    msg_errors bigint
) AS $$
DECLARE
    v_div bigint;
    v_state rpop.collect_states;
    v_cnt int;
BEGIN
    FOR folder IN
        SELECT folder_id
          FROM rpop.rpop_imap_folders
         WHERE popid = i_popid
    LOOP
        v_div := folder % i_modulo;

        msg_count := 0;
        msg_collected := 0;
        msg_errors := 0;

        FOR v_state, v_cnt IN
            SELECT collect_state, COUNT(1) AS cnt
              FROM rpop.rpop_imap_uidls
             WHERE folder_id = folder AND folder_id % i_modulo = v_div
             GROUP BY collect_state
        LOOP
            msg_count := msg_count + v_cnt;
            IF v_state = 'collected' OR v_state = 'rejected' THEN
                msg_collected := msg_collected + v_cnt;
            ELSIF v_state = 'error' OR v_state = 'not_collected' THEN
                msg_errors := msg_errors + v_cnt;
            END IF;
        END LOOP;
        RETURN NEXT;
    END LOOP;

    RETURN;
END;
$$ LANGUAGE plpgsql;

