CREATE OR REPLACE FUNCTION rpop.edit_imap_folder(
    i_folder_id     bigint,
    i_uidvalidity   integer,
    i_uidnext       integer,
    i_message_count integer,
    i_inited        boolean
) RETURNS integer AS $$
DECLARE
    res integer;
BEGIN
    UPDATE rpop.rpop_imap_folders
    SET uidvalidity = i_uidvalidity,
        uidnext = i_uidnext,
        message_count = i_message_count,
        inited = i_inited
    WHERE folder_id = i_folder_id;

    GET DIAGNOSTICS res = ROW_COUNT;
    RETURN res;
END;
$$ LANGUAGE 'plpgsql';
