CREATE OR REPLACE FUNCTION rpop.edit_imap_message(
    i_folder_id     bigint,
    i_uidl          bigint,
    i_collect_state text,
    i_modulo        bigint DEFAULT 64
) RETURNS integer AS $$
DECLARE
    div bigint;
    res integer;
BEGIN
    SELECT i_folder_id % i_modulo INTO div;
    UPDATE rpop.rpop_imap_uidls
        SET collect_state = i_collect_state::rpop.collect_states
        WHERE folder_id = i_folder_id
            AND uidl = i_uidl
            AND folder_id % i_modulo = div;

    GET DIAGNOSTICS res = ROW_COUNT;
    RETURN res;
END;
$$ LANGUAGE 'plpgsql';
