CREATE OR REPLACE FUNCTION rpop.getbusychunk(i_hostname text) RETURNS BIGINT AS
$BODY$
DECLARE
chid bigint;
BEGIN
WITH tmp AS (
    SELECT min(owner) AS owner FROM (
        SELECT owner, count(1) nChunks, Max(count(1)) over() nMaxChunks
            FROM rpop.rpop_service
            WHERE coalesce(owner,' ') != i_hostname
            GROUP BY owner
            HAVING count(1) > (
                SELECT count(1) + 1
                  FROM rpop.rpop_service
                  WHERE owner = i_hostname
            )
    ) m WHERE nChunks = nMaxChunks
)
SELECT chunk_id INTO chid
  FROM rpop.rpop_service rs3, tmp
  WHERE chunk_id = (
    SELECT min(chunk_id)
        FROM rpop.rpop_service rs
        WHERE rs.owner = tmp.owner
          AND (requester IS NULL OR NOT EXISTS (
                SELECT 1
                    FROM rpop.rpop_service rs2
                    WHERE rs2.owner = rs.owner
                      AND rs2.requester IS NULL
                ))
        );
IF ( pg_try_advisory_xact_lock(chid) = true) THEN
    RETURN chid;
ELSE RETURN 0;
END IF;
END
$BODY$
LANGUAGE 'plpgsql';
