create or replace function rpop.gethungchunk(delay integer, i_hostname text) returns bigint as
$BODY$
DECLARE
chid bigint;
begin

select chunk_id into chid from rpop.rpop_service
     where chunk_id =
      (
       select min(chunk_id)
        from rpop.rpop_service
       where
        coalesce(owner,' ') != i_hostname
        and last_connect < current_timestamp - delay * interval '1 seconds'
      );

if ( pg_try_advisory_xact_lock(chid) = true) 
	then RETURN chid;
	else return 0;
end if;

end
$BODY$
LANGUAGE 'plpgsql';
