CREATE OR REPLACE FUNCTION rpop.imap_messages_list(
    i_folder_id bigint,
    i_collect_state text,
    i_limit integer,
    i_modulo bigint DEFAULT 64
) RETURNS SETOF bigint LANGUAGE plpgsql AS $$
DECLARE
    div bigint;
    part text;
    length integer;
BEGIN
    SELECT i_folder_id % i_modulo INTO div;
    SELECT length(i_modulo::text) + 1 INTO length;
    SELECT lpad(div::text, length, '0') INTO part;
    RETURN QUERY EXECUTE format($quote$
        SELECT uidl
            FROM rpop.rpop_imap_uidls_%1$s
            WHERE folder_id = %2$L
                AND (collect_state = %3$L::rpop.collect_states OR
                    (collect_state IS NULL AND %3$L = 'collected'))
            ORDER BY uidl DESC
            LIMIT %4$L
    $quote$, part, i_folder_id, i_collect_state, i_limit);
END;
$$
