CREATE OR REPLACE FUNCTION rpop.imap_uidl_list(
    i_folderid  bigint,
    i_modulo    bigint DEFAULT 64
) RETURNS SETOF text AS $$
DECLARE
    div bigint;
BEGIN
    SELECT i_folderid % i_modulo INTO div;
    RETURN QUERY
        SELECT uidl::text
            FROM rpop.rpop_imap_uidls
            WHERE folder_id = i_folderid
                AND (collect_state = 'collected' OR collect_state = 'rejected' OR collect_state IS NULL)
                AND folder_id % i_modulo = div;
END;
$$ LANGUAGE 'plpgsql';
