create or replace function rpop.rpop_update(i_session_duration bigint, i_last_connect bigint, i_last_msg_count bigint, 
	i_error_status text, i_bad_retries bigint, i_is_on bigint, i_abook_sync_state smallint, i_validated smallint, 
	i_uidl_hash text, i_last_server_answer text, i_popid bigint) 
returns integer as
$BODY$
DECLARE
	res integer;
	new_is_on bigint;
BEGIN
	select is_on into new_is_on from rpop.pop_profile where popid=i_popid;
	if new_is_on <> 0
	then
		new_is_on = i_is_on;
	end if;

	update rpop.pop_profile set session_duration=i_session_duration, last_connect=i_last_connect, 
		last_msg_count=i_last_msg_count, error_status=i_error_status, bad_retries=i_bad_retries, is_on=new_is_on,
		abook_sync_state=i_abook_sync_state, validated=i_validated, uidl_hash=i_uidl_hash, last_server_answer=i_last_server_answer where popid=i_popid;
	GET DIAGNOSTICS res = ROW_COUNT;
	return res;
END
$BODY$
LANGUAGE 'plpgsql';
