CREATE OR REPLACE FUNCTION rpop.traiudrop_profile()
RETURNS trigger LANGUAGE plpgsql AS $$
DECLARE
    c bigint;
    c1 bigint;
BEGIN
    IF (TG_OP = 'INSERT') THEN
        BEGIN
            SELECT max(chunk_id), max(rpop_count)
                INTO c,c1 FROM (
                    SELECT chunk_id,rpop_count
                        FROM rpop.rpop_service_count
                        WHERE rpop_count < getchunksize() limit 1
                ) foo;
            IF (c IS NULL) THEN
                BEGIN
                    SELECT max(chunk_id) INTO c FROM rpop.rpop_service_count;
                    INSERT INTO rpop.rpop_service
                        (chunk_id, owner, requester, last_connect)
                        VALUES (c+1, NULL, NULL, date '1979-01-01');
                    INSERT INTO rpop.rpop_service_count (chunk_id, rpop_count)
                        VALUES (c+1, 1);
                    SELECT c+1 INTO NEW.chunk_id;
                END;
            ELSE
                BEGIN
                    NEW.chunk_id = c;
                    UPDATE rpop.rpop_service_count
                        SET rpop_count=rpop_count+1
                        WHERE chunk_id=c;
                END;
            END IF;
            RETURN NEW;
        END;
    END IF;
    IF (TG_OP = 'DELETE') THEN
        BEGIN
            UPDATE rpop.rpop_service_count
                SET rpop_count = rpop_count - 1
                WHERE chunk_id = OLD.chunk_id;
            RETURN OLD;
        END;
    END IF;
END;
$$;
