CREATE OR REPLACE FUNCTION rpop.update_or_create_http_folder(
	i_popid bigint,
	i_foldername text,
	i_last_synced_message_ts bigint,
	i_message_count bigint,
	i_collected_count bigint,
	i_error_count bigint,
	i_bad_message_retries bigint,
	i_last_synced_message_received_ts bigint default 0
)
RETURNS bigint AS
$$
DECLARE
	i_folder_id bigint;
BEGIN
    LOOP
        UPDATE rpop.rpop_http_folders
			SET
				last_synced_message_ts = i_last_synced_message_ts,
				message_count = i_message_count,
				collected_count = i_collected_count,
				error_count = i_error_count,
				bad_message_retries = i_bad_message_retries,
				last_synced_message_received_ts = i_last_synced_message_received_ts
		WHERE popid = i_popid AND foldername = i_foldername
		RETURNING folder_id INTO i_folder_id;

        IF found THEN
            RETURN i_folder_id;
        END IF;

        BEGIN
			SELECT nextval('rpop.rpop_imap_folders_seq') into i_folder_id;
            INSERT INTO rpop.rpop_http_folders(
				folder_id,
				popid,
				foldername,
				last_synced_message_ts,
				message_count,
				collected_count,
				error_count,
				bad_message_retries,
				last_synced_message_received_ts
			) VALUES (
				i_folder_id,
				i_popid,
				i_foldername,
				i_last_synced_message_ts,
				i_message_count,
				i_collected_count,
				i_error_count,
				i_bad_message_retries,
				i_last_synced_message_received_ts
			);
            RETURN i_folder_id;
        EXCEPTION WHEN unique_violation THEN
            -- Do nothing, and loop to try the UPDATE again.
        END;
    END LOOP;
END;
$$
LANGUAGE 'plpgsql';
