#!/bin/bash

set -eo pipefail

function exists {
    type $1 &> /dev/null
}

if ! exists pgmigrate; then
    echo "pgmigrate not found, run pip3 install yandex-pgmigrate";
    exit 1;
fi;

if [[ "$#" -ne 2 ]]; then
    echo "usage: $0 <conninfo> <info|migrate>"
    exit 1;
fi

pgmigrate -c "$1" -d "." -t latest -a "afterAll:code/,afterAll:grants/" $2 -vv
