CREATE SCHEMA IF NOT EXISTS rpop;

create table rpop.POP_PROFILE
(
    POPID                 bigint not null,
    UNAME                 bigint not null,
    FNAME                 VARCHAR(160) not null,
    SERVER                text not null,
    PORT                  integer default 110 not null,
    LOGIN                 text not null,
    PASSWORD              text not null,
    PRIO                  bigint default '100' not null,
    ENA_FILTERS           bigint default '1' not null,
    IS_ON                 bigint default '1' not null,
    LAST_CONNECT          bigint,
    SESSION_DURATION      bigint,
    BAD_RETRIES           bigint,
    ERROR_STATUS          text,
    LAST_MSG_COUNT        bigint,
    DELETE_MSG            bigint default '0' not null,
    USE_SSL               VARCHAR(1) default 'N',
    EMAIL                 VARCHAR(80),
    DATE_UNREAD           timestamp default current_timestamp,
    ABOOK_SYNC_STATE      smallint default 1 not null,
    ABOOK_SYNC_START_DATE timestamp default current_timestamp + interval '5 minutes' not null,
    CREATE_DATE           timestamp default current_timestamp,
    CHUNK_ID              bigint,
    VALIDATED             smallint default 0,
    UIDL_STORAGE          VARCHAR(1) default 1,
    UIDL_HASH             VARCHAR(64),
    LAST_SERVER_ANSWER    text,
    ARCHIVE_ACTION        smallint,
    USE_IMAP              smallint default 0 not null,
    IMAP_ROOT_FOLDER      VARCHAR(1024),
    ORA_POPID             bigint default null,
    ORA_MIGRATION_DATE    timestamp,
    IS_OAUTH              boolean default null,
    constraint PK_POPPROFILE primary key (POPID)
);

alter table rpop.POP_PROFILE add check (COALESCE(Use_SSL,'U') in ('Y','N'));

create index I_POP_PROFILE on rpop.POP_PROFILE (UNAME);
create index I_POP_PROFILE_CHUNK_ID on rpop.POP_PROFILE (CHUNK_ID);
create unique index i_pop_migrated on rpop.pop_profile (ora_popid) where ora_popid is not null;

create table rpop.RPOP_UIDL
(
    POPID bigint not null,
    UIDL  VARCHAR(200) not null,
    constraint PK_RPOP_UIDL primary key (POPID, UIDL)
);

create table rpop.RPOP_SERVICE_COUNT
(
    CHUNK_ID   bigint,
    RPOP_COUNT integer
);

create table rpop.RPOP_SERVICE
(
    CHUNK_ID     bigint not null,
    OWNER        VARCHAR(200),
    REQUESTER    VARCHAR(200),
    REQUEST_TIME timestamp,
    LAST_CONNECT timestamp,
    constraint PK_RPOP_SERVICE primary key (CHUNK_ID)
);

create table rpop.RPOP_DUPES
(
    UNAME  bigint not null,
    MSG_ID VARCHAR(1024),
    NMSG   integer
);

create index I_RPOP_DUPES_UNAME on rpop.RPOP_DUPES (UNAME);

create table rpop.RPOP_IMAP_FOLDERS
(
    FOLDER_ID     bigint not null,
    POPID         bigint not null  references rpop.POP_PROFILE (POPID) on delete cascade,
    FOLDERNAME    VARCHAR(1024) not null,
    UIDVALIDITY   integer not null,
    UIDNEXT       integer not null,
    MESSAGE_COUNT integer not null,
    constraint PKRPOPIMAPFOLDERS primary key (FOLDER_ID),
    constraint UK_RPOPIMAPFOLDERS_POPID_FN unique (POPID, FOLDERNAME)
);

create index FK_POPPROFILE_POPID on rpop.RPOP_IMAP_FOLDERS (POPID);

create table rpop.RPOP_IMAP_UIDLS
(
    FOLDER_ID bigint not null references rpop.RPOP_IMAP_FOLDERS (FOLDER_ID) on delete cascade,
    UIDL      bigint not null,
    constraint PKRPOPIMAPUIDLS_UNIQ_FN unique (FOLDER_ID, UIDL)
);

create index FK_RPOPIMAPFOLDERS_ID on rpop.RPOP_IMAP_UIDLS (FOLDER_ID);

create sequence rpop.RPOP_IMAP_FOLDERS_SEQ minvalue 1 increment by 1 no maxvalue;
create sequence rpop.POP_S minvalue 1 increment by 1 no maxvalue;
create sequence rpop.rpop_service_count_last_chunk no cycle;
select setval('rpop.rpop_service_count_last_chunk', (select coalesce(max(chunk_id), 1) from rpop.rpop_service_count));

CREATE OR REPLACE FUNCTION rpop.traiudrop_profile()
RETURNS trigger LANGUAGE plpgsql AS $$
DECLARE
    c bigint;
    c1 bigint;
BEGIN
    IF (TG_OP = 'INSERT') THEN
        BEGIN
            SELECT max(chunk_id), max(rpop_count)
                INTO c,c1 FROM (
                    SELECT chunk_id,rpop_count
                        FROM rpop.rpop_service_count
                        WHERE rpop_count < getchunksize() limit 1
                ) foo;
            IF (c IS NULL) THEN
                BEGIN
                    SELECT max(chunk_id) INTO c FROM rpop.rpop_service_count;
                    INSERT INTO rpop.rpop_service
                        (chunk_id, owner, requester, last_connect)
                        VALUES (c+1, NULL, NULL, date '1979-01-01');
                    INSERT INTO rpop.rpop_service_count (chunk_id, rpop_count)
                        VALUES (c+1, 1);
                    SELECT c+1 INTO NEW.chunk_id;
                END;
            ELSE
                BEGIN
                    NEW.chunk_id = c;
                    UPDATE rpop.rpop_service_count
                        SET rpop_count=rpop_count+1
                        WHERE chunk_id=c;
                END;
            END IF;
            RETURN NEW;
        END;
    END IF;
    IF (TG_OP = 'DELETE') THEN
        BEGIN
            UPDATE rpop.rpop_service_count
                SET rpop_count = rpop_count - 1
                WHERE chunk_id = OLD.chunk_id;
            RETURN OLD;
        END;
    END IF;
END;
$$;

CREATE TRIGGER traiudrop_profile_trigger BEFORE INSERT OR DELETE ON
    rpop.pop_profile FOR EACH ROW EXECUTE PROCEDURE rpop.traiudrop_profile();
