DROP SCHEMA IF EXISTS monitor CASCADE;

CREATE SCHEMA monitor;

CREATE VIEW monitor.bad_rpop_by_rpopper AS
SELECT
    COUNT (
        1 ) AS cnt,
    rp.owner
FROM
    rpop.rpop_service rp,
    rpop.pop_profile pp
WHERE
    rp.chunk_id = pp.chunk_id
    AND TO_TIMESTAMP (
        (
            pp.last_connect + 3600 ) ::double precision )
    < NOW ( )
    AND pp.is_on = 1
    AND pp.bad_retries < 2
    AND pp.uname > 0
GROUP BY
    rp.owner
HAVING
    COUNT (
        1 )
    > 100
ORDER BY
    COUNT (
        1 )
    DESC;

CREATE VIEW monitor.bad_rpop_by_server AS
SELECT
    COUNT (
        1 ) AS cnt,
    pp.server
FROM
    rpop.pop_profile pp
WHERE
    TO_TIMESTAMP (
        (
            pp.last_connect + 3600 ) ::double precision )
    < NOW ( )
    AND pp.is_on = 1
    AND pp.bad_retries < 2
    AND pp.uname > 0
GROUP BY
    pp.server
HAVING
    COUNT (
        1 )
    > 10
ORDER BY
    COUNT (
        1 )
    DESC;

CREATE VIEW monitor.bad_rpop_total AS
SELECT
    COUNT (
        1 ) AS cnt
FROM
    rpop.pop_profile
WHERE
    TO_TIMESTAMP (
        (
            pop_profile.last_connect + 3600 ) ::double precision )
    < NOW ( )
    AND pop_profile.is_on = 1
    AND pop_profile.bad_retries < 2
    AND pop_profile.uname > 0;

CREATE VIEW monitor.bad_rpop_ng AS
SELECT
    COUNT (
        1 ) AS cnt
FROM
    rpop.pop_profile
WHERE
    TO_TIMESTAMP (
        (
            pop_profile.last_connect + 3600 ) ::double precision )
    < NOW ( )
    AND pop_profile.is_on = 1
    AND pop_profile.bad_retries < 2
    AND pop_profile.uname > 0
    AND is_ng = 'true';

DROP SCHEMA IF EXISTS stat CASCADE;
