CREATE VIEW monitor.bad_rpop_ng_by_server AS
SELECT COUNT(
        1 ) AS cnt,
    pp.server
FROM
    rpop.pop_profile pp
WHERE
    TO_TIMESTAMP (
        (
            pp.last_connect + 3600 )::double precision )
    < NOW( )
    AND pp.is_on = 1
    AND pp.bad_retries < 2
    AND pp.uname > 0
    AND pp.is_ng = true
GROUP BY
    pp.server
HAVING
    COUNT(1) > 10
ORDER BY
    COUNT (
    1 )
    DESC;
