CREATE VIEW monitor.bad_rpop_ng_by_rpopper AS
SELECT COUNT(
        1 ) AS cnt,
    rp.owner
FROM
    rpop.pop_profile pp,
    rpop.rpop_service rp
WHERE
    TO_TIMESTAMP (
        (
            pp.last_connect + 3600 )::double precision )
    < NOW( )
    AND rp.chunk_id = pp.chunk_id
    AND pp.is_on = 1
    AND pp.bad_retries < 2
    AND pp.uname > 0
    AND pp.is_ng = true
GROUP BY
    rp.owner
HAVING
    COUNT(1) > 100
ORDER BY
    COUNT (
    1 )
    DESC;
