CREATE TABLE rpop.rpop_http_folders
(
    folder_id BIGINT NOT NULL,
    popid         BIGINT NOT NULL REFERENCES rpop.pop_profile (popid) ON DELETE CASCADE,
    foldername    TEXT NOT NULL,
    last_synced_message_ts BIGINT NOT NULL,
    message_count BIGINT NOT NULL,
    collected_count BIGINT NOT NULL,
    error_count BIGINT NOT NULL,
    bad_message_retries     BIGINT NOT NULL,
    skipped_mids TEXT[] NOT NULL DEFAULT ARRAY[]::TEXT[],
    CONSTRAINT pk_rpop_http_folders PRIMARY KEY (folder_id),
    CONSTRAINT uk_rpop_http_folders_popid_fn UNIQUE (popid, foldername)
);
