#!/bin/sh

GOLEM_URL="https://golem.yandex-team.ru/api/net_query.sbml?all=y";
NETS_FILE="/etc/collectors-ext/yandex_nets.txt";
SMALL_FILE=500;

PIDFILE=/tmp/get-yandex-nets.pid

# kill other instanses if found
[ -s $PIDFILE ] && kill -KILL `cat $PIDFILE` ; echo $$ > $PIDFILE

if wget -q --no-check-certificate -t2 -T60 -O $NETS_FILE.tmp $GOLEM_URL ; then
	if [ -s $NETS_FILE.tmp ] ; then
		if [ `wc -l $NETS_FILE.tmp | awk '{print $1}'` -gt $SMALL_FILE ] ; then
			NETS_MD5=`cat $NETS_FILE | sort | md5sum`;
			NETS_MD5_TMP=`cat $NETS_FILE.tmp | sort | md5sum`;
			rm -f $PIDFILE;
		else
			logger daemon.err "get-yandex-nets: error: new nets file too small";
			rm -f $NETS_FILE.tmp;
			rm -f $PIDFILE;
			exit -1;
		fi
		if [ "$NETS_MD5" != "$NETS_MD5_TMP" ] ; then
			mv -f $NETS_FILE.tmp $NETS_FILE || logger -p daemon.err "get-yandex-nets: can not update $NETS_FILE";
			rm -f $PIDFILE;
			exit 0;
		else
			rm -f $NETS_FILE.tmp;
			rm -f $PIDFILE;
			exit 0;
		fi
	else
		logger -p daemon.err "get-yandex-nets: error: $NETS_FILE.tmp are missing or empty";
		rm -f $NETS_FILE.tmp;
		rm -f $PIDFILE;
		exit -1;
	fi
else
	logger -p daemon.err "get-yandex-nets: error: cannot download $NETS_URL";
	rm -f $NETS_FILE.tmp;
	rm -f $PIDFILE;
	exit -1 ;
fi
