#!/bin/bash

set -eux

environment="$(cat /etc/environment.name)"
export CONFIG_DIR=/usr/share/collectors-ext/oauth_token_loader/config
export TOKEN_LOADER_CONFIG_PATH=$CONFIG_DIR/${environment}.yml
export SHARDS_CONFIG_PATH=/etc/collectors-ext/shards/${environment}.yml

[[ ! -f $TOKEN_LOADER_CONFIG_PATH ]] && exit 1

export PGPASSFILE=$CONFIG_DIR/.pgpass
[[ -f $PGPASSFILE ]] && chmod 0600 $PGPASSFILE

if [[ $environment == 'import' ]]; then
    TVM_DST=222
    TVM_SRC=2025684
elif [[ $environment == 'testing' ]]; then
    TVM_DST=224
    TVM_SRC=2025686
elif [[ $environment == 'dev' ]]; then
    TVM_DST=224
    TVM_SRC=2025686
fi

cat /etc/collectors-ext/tvm_secret | ya tool tvmknife get_service_ticket client_credentials --src $TVM_SRC --dst $TVM_DST > "$CONFIG_DIR/.blackbox.token"

/usr/share/collectors-ext/oauth_token_loader/reload_tokens.py --file /var/collectors-ext/data/access_tokens

pkill -SIGHUP collectors-ext
