#!/bin/bash

[[ "$TRACE" ]] && set -x
set -eo pipefail

ts=$(date +%s)
prefix="http.responses."

function run()
{
    timetail -n 60 -r '^tskv\ttskv_format=collectors-ext-access-log\ttimestamp=.{11}(\d\d:\d\d:\d\d)' $1 | head -n -1 | \
    awk -v prefix=$prefix -v ts=$ts '
        @include "/usr/share/yandex-mail-common/metrics-util.awk"

        {
            code = get_tskv_value($0, "status_code")
            status = get_tskv_value($0, "status")
            tm = get_tskv_value($0, "profiler_exec")
            request = get_tskv_value($0, "request")
            path_end = index(request, "?") - 1
            if (path_end == -1) {
                path_end = length(request)
            }
            request = substr(request, 2, path_end - 1)
            gsub("[/]","_",request)
            gsub("^_*", "", request)

            if (length(code) > 0 &&
                length(request) > 0 &&
                length(tm) > 0) # filter malformed entries
            {
                http["total"]++
                http["codes.total."code]++
                http["codes."request"."code]++
                if (length(status) > 0) {
                    http["statuses.total."status]++
                    http["statuses."request"."status]++
                }

                collect_timings(tm, "total", http_tm)
                collect_timings(tm, request, http_tm)
            }
        }
        END {
            for (metric in http) {
                print prefix metric, http[metric], ts
            }
            for (entry in http_tm) {
                print prefix "timings." entry, "[" http_tm[entry] "]", ts
            }
        }'
}

run /var/log/collectors-ext/access.log
