#!/bin/bash

[[ "$TRACE" ]] && set -x
set -eo pipefail

ts=$(date +%s)
prefix="task."
log="/var/log/collectors-ext/collectors-ext.log"

timetail -n 60 -t imap $log | head -n -1 | \
awk -v prefix=$prefix -v ts=$ts '
@include "/usr/share/yandex-mail-common/metrics-util.awk"

/task skipped/ {
    match ($0, "task skipped \\((.*)\\):", match_res)
    reason = match_res[1]
    gsub(" ", "_", reason)
    skips[reason]++
}

/not master\, skipping/ {
    skips["not_master"]++
}

END {
    for (reason in skips) {
        print prefix "skipped.reason." reason, skips[reason], ts
    }
}'
