#!/bin/bash

[[ "$TRACE" ]] && set -x
set -eo pipefail

ts=$(date +%s)
prefix="tenant_access_tokens."
tokens_file="/var/collectors-ext/data/access_tokens"
log_file="/var/log/collectors-ext/oauth_token_loader/loader.log"

awk -v prefix=$prefix -v ts=$ts '
{
    match ($0, "@([a-zA-Z0-9._-]+)", match_res)
    domain = match_res[1]
    secret = $2
    if (length(secret) < 1000) {
        provider = "gmail"
    } else {
        provider = "ms365"
    }
    emails[provider][domain]++
}

END {
    for (provider in emails) {
        for (domain in emails[provider]) {
            print prefix "orgs." provider, 1, ts, domain
            print prefix "emails", emails[provider][domain], ts, domain
        }
    }
}' $tokens_file


timetail -n600 -r '^(\d\d\d\d-\d\d-\d\d \d\d:\d\d:\d\d)' $log_file | \
awk -v prefix=$prefix -v ts=$ts '

/failed get delegated token/ {
    match ($0, "failed get delegated token for login=.*@([a-zA-Z0-9._-]+)", match_res)
    domain = match_res[1]
    delegated_token_errors[domain]++
}

/domain validity check failed/ {
    match ($0, "domain validity check failed for login=.*@([a-zA-Z0-9._-]+)", match_res)
    domain = match_res[1]
    domain_errors[domain]++
}

/failed to get bb info/ {
    match ($0, "failed to get bb info for login=.*@([a-zA-Z0-9._-]+)", match_res)
    domain = match_res[1]
    bb_errors[domain]++
}

/failed to load secret from tractor api/ {
    match ($0, "failed to load secret from tractor api for domain=([a-zA-Z0-9._-]+) orgid=[0-9]+: (.*), will try ipa db", match_res)
    domain = match_res[1]
    reason = match_res[2]
    if (reason == "no secrets from api") {
        no_secrets_from_tractor[domain]++
        no_secrets[domain]++
    } else {
        bad_secret_from_tractor[domain]++
        bad_secret[domain]++
    }
}

/loaded secret from tractor api/ {
    match ($0, "loaded secret from tractor api for domain=([a-zA-Z0-9._-]+) orgid=[0-9]+", match_res)
    domain = match_res[1]
    secret_loaded_from_tractor[domain]++
    secret_loaded[domain]++
}

/failed to load secret from ipa db/ {
    match ($0, "failed to load secret from ipa db for domain=([a-zA-Z0-9._-]+) orgid=[0-9]+: (.*)", match_res)
    domain = match_res[1]
    reason = match_res[2]
    if (reason == "no secrets in db") {
        no_secrets_in_db[domain]++
        no_secrets[domain]++
    } else {
        bad_secret_from_db[domain]++
        bad_secret[domain]++
    }
}

/loaded secret from ipa db/ {
    match ($0, "loaded secret from ipa db for domain=([a-zA-Z0-9._-]+) orgid=[0-9]+", match_res)
    domain = match_res[1]
    secret_loaded_from_db[domain]++
    secret_loaded[domain]++
}

END {
    for (domain in delegated_token_errors) {
        print prefix "error.delegated_token", delegated_token_errors[domain], ts, domain
    }
    for (domain in domain_errors) {
        print prefix "error.invalid_domain", domain_errors[domain], ts, domain
    }
    for (domain in bb_errors) {
        print prefix "error.bb_error", bb_errors[domain], ts, domain
    }
    for (domain in no_secrets_in_db) {
        print prefix "error.no_secrets_in_db", 1, ts, domain
    }
    for (domain in bad_secret_from_db) {
        print prefix "error.bad_secret_from_db", 1, ts, domain
    }
    for (domain in secret_loaded_from_db) {
        print prefix "secret_loaded_from_db", 1, ts, domain
    }
    for (domain in no_secrets_from_tractor) {
        print prefix "error.no_secrets_from_tractor", 1, ts, domain
    }
    for (domain in bad_secret_from_tractor) {
        print prefix "error.bad_secret_from_tractor", 1, ts, domain
    }
    for (domain in secret_loaded_from_tractor) {
        print prefix "secret_loaded_from_tractor", 1, ts, domain
    }
    for (domain in no_secrets) {
        print prefix "error.no_secrets", 1, ts, domain
    }
    for (domain in bad_secret) {
        print prefix "error.bad_secret", 1, ts, domain
    }
    for (domain in secret_loaded) {
        print prefix "secret_loaded", 1, ts, domain
    }
}'
