#!/bin/bash

[[ "$TRACE" ]] && set -x
set -eo pipefail

ts=$(date +%s)
prefix="sessions."
log="/var/log/collectors-ext/typed.log"

timetail -n 60 -r '^tskv\ttskv_format=collectors-log\ttimestamp=(\d\d\d\d-\d\d-\d\d \d\d:\d\d:\d\d)' $log | head -n -1 | \
awk -v prefix=$prefix -v ts=$ts '
@include "/usr/share/yandex-mail-common/metrics-util.awk"
@include "/usr/share/collectors-ext/get_provider_from_server.awk"

{
    type = get_tskv_value($0, "type")
    if (type == "iteration")
    {
        duration = get_tskv_value($0, "duration")
        sent_count = get_tskv_value($0, "sent_count")
        src_type = get_tskv_value($0, "src_type")
        reason = get_tskv_value($0, "reason")
        sub(/: .*/, "", reason)
        gsub(" ", "_", reason)
        if (length(duration) > 0 &&
            length(sent_count) > 0 &&
            length(reason) > 0 &&
            length(src_type) > 0) # filter malformed entries
        {
            server = get_tskv_value($0, "server")
            provider = get_provider_from_server(server)

            sessions[provider ":finished_statuses." src_type "." reason]++
            sessions[provider ":collected_messages." src_type] += sent_count

            collect_timings(duration, provider ":duration." src_type, sessions_duration)
        }
    }
}
END {
    for (metric in sessions) {
        split(metric,r,":")
        print prefix r[2], sessions[metric], ts, r[1]
    }
    for (entry in sessions_duration) {
        split(entry,r,":")
        print prefix r[2], "[" sessions_duration[entry] "]", ts, r[1]
    }
}'
