from settings import settings
from urllib.parse import urlencode
import requests
import json

ORG_IDS_ATTR = "1017"


class Blackbox:
    def __init__(self):
        self.settings = settings().blackbox
        self.credentials = open(self.settings.tvm_secret_file).read().strip()

    def userinfo(self, suid):
        user = self._userinfo(suid=suid, sid=2, attributes=ORG_IDS_ATTR)
        info = {
            "org_id": user.get("attributes", {}).get(ORG_IDS_ATTR),
            "domain": user.get("uid").get("domain"),
        }
        return info

    def suid(self, uid):
        user = self._userinfo(uid=uid, dbfields="subscription.suid.2")
        dbfields = user.get("dbfields")
        if not dbfields:
            raise RuntimeError("user not found: no dbfields")
        suid = dbfields.get("subscription.suid.2")
        if not suid:
            raise RuntimeError("user not found: no suid")
        return suid

    def _userinfo(self, **kwargs):
        res = self._do_request(method="userinfo", userip="127.0.0.1", emails="getall", **kwargs)
        if len(res["users"]) == 0:
            raise RuntimeError("user not found")
        user = res["users"][0]
        if not user["uid"]:
            raise RuntimeError("user not found")
        return user

    def _do_request(self, **kwargs):
        kwargs["format"] = "json"
        headers = {"User-Agent": self.settings.user_agent, "X-Ya-Service-Ticket": self.credentials}
        resp = requests.get(
            f"{self.settings.base_url}/blackbox?{urlencode(kwargs)}",
            headers=headers,
            timeout=self.settings.timeout,
        )
        resp.raise_for_status()
        resp_data = resp.json()
        if "exception" in resp_data:
            raise RuntimeError(
                "blackbox error {} {}".format(resp_data["exception"]["value"], resp_data["error"])
            )
        return resp_data
