from settings import settings
from provider import Provider
import psycopg2

import socket


def my_owner_name():
    return socket.gethostname()


GMAIL_IMAP_SERVER = "imap.gmail.com"
FAKE_LOGIN = "migration-meta"


class CollectorsDatabase:
    def __init__(self):
        self.settings = settings().collectors_db

    def make_connection(self, conninfo):
        conn = psycopg2.connect(conninfo)
        conn.set_session(readonly=True, autocommit=True)
        return conn

    def list_imap_oauth(self):
        collectors = []
        for shard_conninfo in self.settings:
            conn = self.make_connection(shard_conninfo)
            cur = conn.cursor()
            cur.execute(
                """
            SELECT
                popid,
                uname,
                login,
                server
            FROM rpop.pop_profile pp
            WHERE
                is_oauth = 't'
                AND use_imap = 1
                AND is_on <> 0
                AND uname > 0
                AND exists (select 1 from rpop.rpop_service where pp.chunk_id = chunk_id and owner=%(owner)s)
            """,
                {
                    "owner": my_owner_name()
                },
            )
            items = cur.fetchall()
            for popid, suid, login, server in items:
                collectors.append({"popid": popid, "suid": suid, "login": login, "server": server})
        return collectors


class IPADatabase:
    def __init__(self):
        self.settings = settings().ipa_db

    def make_connection(self):
        return psycopg2.connect(
            self.settings.conninfo,
            keepalives=1,
            keepalives_idle=30,
            keepalives_interval=10,
            keepalives_count=5,
        )

    def get_last_password(self, org_id: str, provider: Provider):
        params = self._get_last_import_params(org_id, provider.fake_login())
        if params is None:
            raise RuntimeError("no secrets in db")
        user_info = params[0]["users"][0]
        return user_info["password"]

    def _get_last_import_params(self, org_id, fake_login):
        with self.make_connection() as conn:
            with conn.cursor() as cur:
                cur.execute(
                    """
                SELECT params
                FROM tasks
                WHERE entity_id = %s AND task_type = 'init_import' AND params#>>'{users,0,src_login}' = %s
                ORDER BY CREATED DESC
                LIMIT 1
                """,
                    (org_id, fake_login),
                )
                return cur.fetchone()
