from base64 import b64decode
from crypto import Fernet, VersionedKeyStorage

from settings import settings

import json


class Decryptor:
    def __init__(self):
        key_version_storage = VersionedKeyStorage(settings().key_versions)
        self.fernet = Fernet(key_version_storage)

    def decrypt(self, password):
        secret_base64 = self.fernet.decrypt(b64decode(password)).decode("utf8")
        return json.loads(b64decode(secret_base64))
