from google.oauth2 import service_account
from google_auth_httplib2 import Request
from googleapiclient import _auth

SCOPES = ["https://mail.google.com/"]


class GoogleServiceCredentials:
    def __init__(self, secret):
        self.credentials = service_account.Credentials.from_service_account_info(
            secret, scopes=SCOPES
        )

    def get_token(self, login):
        delegated_credentials = self.credentials.with_subject(login)
        http = _auth.authorized_http(delegated_credentials)
        request = Request(http)

        delegated_credentials.refresh(request)
        return delegated_credentials.token
