from settings import settings
import logging
import os


def setup_log():
    logger = logging.getLogger("token_loader_log")
    logger.setLevel(logging.INFO)
    os.makedirs(os.path.dirname(settings().log_path), exist_ok=True)
    fh = logging.FileHandler(settings().log_path)
    ch = logging.StreamHandler()
    ch.setLevel(logging.DEBUG)
    formatter = logging.Formatter("%(asctime)s %(levelname)s %(message)s")
    fh.setFormatter(formatter)
    ch.setFormatter(formatter)
    logger.addHandler(fh)
    logger.addHandler(ch)
    return logger


log = setup_log()
